(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11106,        396]*)
(*NotebookOutlinePosition[     12009,        426]*)
(*  CellTagsIndexPosition[     11965,        422]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Second Series Solution"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Given a series solution y1[x], we use the formula \n\t\t",
  Cell[BoxData[
      \(y2[x] = 
        y1[x]\ \(\[Integral]\(\[ExponentialE]\^\(-\(\[Integral]\(p1[x]\/p2[x]\
\) \[DifferentialD]x\)\)\/y1[x]\^2\) \[DifferentialD]x\)\)]],
  "\nto find a second solution y2[x].\n\nThe steps are all shown for two \
reasons: (1) so you can see them, and (2) you may have to manually simplify \
g[x]. Otherwise the process could be automated."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["State the sample problem"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Solve\t x^2 y''[x]+(2x-5)y'[x]+9y[x]==0 \tby series about x0==0."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y, L]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{\(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"x", " ", \((2\ x - 5)\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(9\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{\(9\ y[x]\), "+", 
      RowBox[{"x", " ", \((\(-5\) + 2\ x)\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The first solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "In the next cell, we are given one solution to  ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\ \(y''\)[x] + x \((2  x - 5)\) \(y'\)[x] + 
          9  y[x]\  == \ 0\)]],
  ".\nIf you use this notebook to solve a different equation, you will need \
to supply one solution in the following cell in place of the one we have \
used."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = 
      x\^3 + \[Sum]\+\(n = 1\)\%10\(\((\(-1\))\)\^n\ 2\^\(n - 1\)\ \((n + \
1)\)\ \((n + 2)\)\ x\^\(n + 3\)\)\/\(n!\) + O[x]\^11\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(x\^3\), "-", \(6\ x\^4\), "+", \(12\ x\^5\), 
        "-", \(\(40\ x\^6\)\/3\), "+", \(10\ x\^7\), "-", \(\(28\ x\^8\)\/5\),
         "+", \(\(112\ x\^9\)\/45\), "-", \(\(32\ x\^10\)\/35\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 3, 11, 1]]}],
      SeriesData[ x, 0, {1, -6, 12, 
        Rational[ -40, 3], 10, 
        Rational[ -28, 5], 
        Rational[ 112, 45], 
        Rational[ -32, 35]}, 3, 11, 1]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Calculate Exp[-Integrate[p1[x]/p2[x],x]]"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[x_] = 
      Exp[\(-\(\[Integral]\(\(x\ \((2\ x - 
                          5)\)\)\/x\^2\) \[DifferentialD]x\)\)] /. 
        Exp[a_ + b_] \[RuleDelayed] Exp[a]\ Exp[b]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-2\)\ x\)\ x\^5\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The other factor"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here is 1/y1[x]^2."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(1\/y1[x]\^2\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(1\/x\^6\), "+", \(12\/x\^5\), "+", \(84\/x\^4\), 
        "+", \(1376\/\(3\ x\^3\)\), "+", \(2188\/x\^2\), 
        "+", \(48176\/\(5\ x\)\), "+", \(1814848\/45\), 
        "+", \(\(5708928\ x\)\/35\), "+", 
        InterpretationBox[\(O[x]\^2\),
          SeriesData[ x, 0, {}, -6, 2, 1]]}],
      SeriesData[ x, 0, {1, 12, 84, 
        Rational[ 1376, 3], 2188, 
        Rational[ 48176, 5], 
        Rational[ 1814848, 45], 
        Rational[ 5708928, 35]}, -6, 2, 1]]], "Output"]
}, Closed]],

Cell[TextData["Here is the other factor"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(other = 
      Normal[\[Integral]\(g[x]\/y1[x]\^2\) \[DifferentialD]x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(10\ x + 
      31\ x\^2 + \(940\ x\^3\)\/9 + \(2135\ x\^4\)\/6 + \(91084\ x\^5\)\/75 + \
\(111946\ x\^6\)\/27 + \(31213288\ x\^7\)\/2205 + Log[x]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Separate into parts: The Log[x] part"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(LogPart = Coefficient[other, Log[x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Separate into parts: The series part (as a polynomial)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolyPart = other - LogPart\ Log[x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(10\ x + 
      31\ x\^2 + \(940\ x\^3\)\/9 + \(2135\ x\^4\)\/6 + \(91084\ x\^5\)\/75 + \
\(111946\ x\^6\)\/27 + \(31213288\ x\^7\)\/2205\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The second solution (Displayed)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The function ",
  StyleBox["HoldForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is used to display the result as it is usually seen with y1[x] explicitly \
evident. The second solution y2[x] is actually computed in the cell \
following."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        TagBox[\(y1[x]\),
          HoldForm], " ", \((LogPart\ Log[x])\)}], "+", 
      RowBox[{
        TagBox[\(y1[x]\),
          HoldForm], " ", "PolyPart"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{\((10\ x + 
            31\ x\^2 + \(940\ x\^3\)\/9 + \(2135\ x\^4\)\/6 + \(91084\ x\^5\)\
\/75 + \(111946\ x\^6\)\/27 + \(31213288\ x\^7\)\/2205)\), " ", 
        TagBox[\(y1[x]\),
          HoldForm]}], "+", 
      RowBox[{
        TagBox[\(y1[x]\),
          HoldForm], " ", \(Log[x]\)}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The second solution (Defined)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here are the first terms of the actual y2[x]:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[x_] = y1[x]\ \((LogPart\ Log[x])\) + y1[x]\ PolyPart\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(Log[x]\ x\^3\), "+", \(\((10 - 6\ Log[x])\)\ x\^4\), 
        "+", \(\((\(-29\) + 12\ Log[x])\)\ x\^5\), 
        "+", \(\((346\/9 - \(40\ Log[x]\)\/3)\)\ x\^6\), 
        "+", \(\((\(-\(193\/6\)\) + 10\ Log[x])\)\ x\^7\), 
        "+", \(\((1459\/75 - \(28\ Log[x]\)\/5)\)\ x\^8\), 
        "+", \(\((\(-\(2062\/225\)\) + \(112\ Log[x]\)\/45)\)\ x\^9\), 
        "+", \(\((38876\/11025 - \(32\ Log[x]\)\/35)\)\ x\^10\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 3, 11, 1]]}],
      SeriesData[ x, 0, {
        Log[ x], 
        Plus[ 10, 
          Times[ -6, 
            Log[ x]]], 
        Plus[ -29, 
          Times[ 12, 
            Log[ x]]], 
        Plus[ 
          Rational[ 346, 9], 
          Times[ 
            Rational[ -40, 3], 
            Log[ x]]], 
        Plus[ 
          Rational[ -193, 6], 
          Times[ 10, 
            Log[ x]]], 
        Plus[ 
          Rational[ 1459, 75], 
          Times[ 
            Rational[ -28, 5], 
            Log[ x]]], 
        Plus[ 
          Rational[ -2062, 225], 
          Times[ 
            Rational[ 112, 45], 
            Log[ x]]], 
        Plus[ 
          Rational[ 38876, 11025], 
          Times[ 
            Rational[ -32, 35], 
            Log[ x]]]}, 3, 11, 1]]], "Output"]
}, Closed]],

Cell[TextData["Check both solutions"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[Normal[L[x, y2]]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(128\ x\^10\)\/35\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, y1]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[\(O[x]\^11\),
      SeriesData[ x, 0, {}, 11, 11, 1]]], "Output"]
}, Closed]],

Cell["\<\
This implies that y2 satisfies the differential equation through \
terms in x^9 and y1 satisfies the differential equation through terms in \
x^10.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{533, 546},
WindowMargins->{{42, Automatic}, {Automatic, 31}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 256}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 101, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1880, 57, 514, 11, 149, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2419, 72, 102, 2, 56, "Section",
  Evaluatable->False],
Cell[2524, 76, 140, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2689, 83, 492, 12, 45, "Input"],
Cell[3184, 97, 384, 9, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3617, 112, 96, 2, 36, "Section",
  Evaluatable->False],
Cell[3716, 116, 411, 10, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4152, 130, 198, 4, 61, "Input"],
Cell[4353, 136, 512, 11, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4914, 153, 118, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5057, 159, 231, 5, 42, "Input"],
Cell[5291, 166, 70, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5410, 173, 94, 2, 36, "Section",
  Evaluatable->False],
Cell[5507, 177, 93, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5625, 183, 71, 2, 44, "Input"],
Cell[5699, 187, 536, 12, 76, "Output"]
}, Closed]],
Cell[6250, 202, 99, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6374, 208, 130, 3, 44, "Input"],
Cell[6507, 213, 179, 3, 82, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6723, 221, 117, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6865, 227, 96, 2, 27, "Input"],
Cell[6964, 231, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7048, 238, 136, 3, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7209, 245, 94, 2, 27, "Input"],
Cell[7306, 249, 170, 3, 82, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7537, 259, 109, 2, 36, "Section",
  Evaluatable->False],
Cell[7649, 263, 332, 10, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8006, 277, 244, 8, 27, "Input"],
Cell[8253, 287, 345, 9, 83, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8647, 302, 107, 2, 36, "Section",
  Evaluatable->False],
Cell[8757, 306, 119, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8901, 312, 115, 2, 27, "Input"],
Cell[9019, 316, 1345, 42, 130, "Output"]
}, Closed]],
Cell[10379, 361, 94, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10498, 367, 83, 2, 27, "Input"],
Cell[10584, 371, 52, 1, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10673, 377, 67, 2, 27, "Input"],
Cell[10743, 381, 101, 2, 29, "Output"]
}, Closed]],
Cell[10859, 386, 219, 6, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

ut"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8971, 272, 107, 2, 70, "Section"],
Cell[9081, 276, 119, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[9223, 280, 115, 2, 70, "Input"],
Cell[9341, 284, 1839, 54, 70, "Output"]
}, Closed]],
Cell[11192, 340, 94, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[11309, 344, 83, 2, 70, "Input"],
Cell[11395, 348, 120, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[11547, 353, 67, 2, 70, "Input"],
Cell[11617, 357, 171, 4, 70, "Output"]
}, Closed]],
Cell[11800, 363, 223, 5, 70, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
